# 变量
变量可以被视为能容纳一个值的的容器，并且可以命名
`=` 运算符用于声明一个变量并为其存储一个值。

`variable_name = value`

运算符的左边是变量名。你可以给它取任何你想要的名字。
右边是一个表达式，其结果值将被存储在变量中。

声明一个名为 `a` 的变量，并在其中存储值 `5`：
`a = 5`
声明一个名为 `b` 的变量，并在其中存储 `can_harvest()` 的返回值：
`b = can_harvest()`

不要把 `=` 运算符和 `==` 运算符搞混了。
`==` 运算符检查两个值是否相等，并返回 `True` 或 `False`。
`=` 运算符将右边的值赋给左边的名称。

给变量赋值后，即可在代码中使用该变量来检索它包含的值。

`a = 5
for i in range(a):
	do_a_flip()`

上面的循环执行了 5 次，因为 `a` 被设置为了 `5`。
`for` 循环中的 `i` 也是一个变量，它在循环的每次迭代中被自动赋为序列的当前值。（它不一定非要叫 `i`，你可以给它取任何有效的变量名。）

变量也让你能用 `while` 循环做同样的事情：

`a = 5
i = 0
while i < a:
	do_a_flip()
	i = i + 1`

这和上面的 `for` 循环做的是同样的事情。我们只需要手动递增 `i`。
注意，要递增 i，我们把它设为它自己的值加上 `1`。根据变量的旧值来改变它的值是十分常见的操作。
这些运算符可以用来简化过程：`+=, -=, *=, /=, %=`

`i = i + 1` 和 `i += 1` 是一样的
`a = a / 3` 和 `a /= 3` 是一样的
